//==============================================================================
// Project:		Wealth Transfers and their economic effects
// File name:	IWP 2
// Objective: 	Part 2 of IWP work - generate partner characteristic variables
//
//==============================================================================

clear all

************************
*** Data import ********
************************

cd "XXXX" //set content directory here

use combined_filtered_restricted.dta, replace

merge m:1 xwaveid wave using individual_weight_vars_restricted.dta //individual wealth variables 
drop if _merge == 2
drop _merge

drop if hgint == 0 //drop non-responders

************************
*** Create variables ***
************************
gen net_worth = pwassei - pwdebti //individual net worth

gen university = . //indicator for whether attended university
replace university = 1 if edhigh1 == 1 | edhigh1 == 2 | edhigh1 == 3 //went to university
replace university = 0 if edhigh1 == 4 | edhigh1 == 5 | edhigh1 == 8 | edhigh1 == 9 //didn't go to university

gen school = edhists //indicator for highest level of schooling
replace school = 3 if edhists >= 3 & edhists <= 6 // 1 is grade 12, 2 is grade 11, 3 is highschool but not higher than grade 10, 4 is primary school and special needs (these match the categories from IWP 1)
replace school = 4 if edhists >= 7 & edhists <= 9
replace school = . if edhists < 0 

gen birth_country = anbcob //indicator for country of birth
replace birth_country = . if anbcob == -4 //1 is Australia, 2 is main English speaking, 3 is other (these match the categories from IWP 1)

keep yodeath wave xwaveid university sex school yob birth_country net_worth //rename to distinguish from non-partner variables when merged into IWP 3.do
rename xwaveid hhpxid
rename yodeath yodeath_partner
rename school school_partner
rename university university_partner
rename sex sex_partner
rename yob yob_partner
rename birth_country birth_country_partner
rename net_worth net_worth_partner

save IWP_data_2.dta, replace

